<?php

namespace App\Console\Commands;

use App\Models\License;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class GenerateLicense extends Command
{
    protected $signature = 'license:generate {count=1} {--expires=} {--max=1}';
    protected $description = 'Generate license keys';

    public function handle(): int
    {
        $count = (int) $this->argument('count');
        $expires = $this->option('expires'); // e.g. 2026-12-31
        $max = (int) $this->option('max');

        for ($i=0; $i<$count; $i++) {
            $key = strtoupper(Str::random(4).'-'.Str::random(4).'-'.Str::random(4).'-'.Str::random(4));

            License::create([
                'key' => $key,
                'status' => 'new',
                'max_activations' => max(1, $max),
                'expires_at' => $expires ? $expires.' 23:59:59' : null,
            ]);

            $this->info($key);
        }

        return self::SUCCESS;
    }
}
