<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminBasicAuth
{
    public function handle(Request $request, Closure $next)
    {
        $user = (string) env('LICENSE_ADMIN_USER', '');
        $pass = (string) env('LICENSE_ADMIN_PASS', '');

        if ($user === '' || $pass === '') {
            abort(500, 'Admin credentials are not configured.');
        }

        $givenUser = (string) ($request->getUser() ?? '');
        $givenPass = (string) ($request->getPassword() ?? '');

        if (!hash_equals($user, $givenUser) || !hash_equals($pass, $givenPass)) {
            return response('Unauthorized', 401, [
                'WWW-Authenticate' => 'Basic realm="License Admin"',
            ]);
        }

        return $next($request);
    }
}
