<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LicenseActivation extends Model
{
    protected $fillable = [
        'license_id',
        'fingerprint_hash',
        'domain',
        'ip',
        'app_version',
        'activated_at',
        'last_check_at',
    ];

    protected $casts = [
        'activated_at' => 'datetime',
        'last_check_at' => 'datetime',
    ];

    public function license(): BelongsTo
    {
        return $this->belongsTo(License::class);
    }
}
