<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('license_activations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('license_id')->constrained('licenses')->cascadeOnDelete();
            $table->string('fingerprint_hash', 64);
            $table->string('domain', 255)->nullable();
            $table->string('ip', 45)->nullable();
            $table->string('app_version', 50)->nullable();
            $table->timestamp('activated_at')->nullable();
            $table->timestamp('last_check_at')->nullable();
            $table->timestamps();

            $table->index(['license_id', 'fingerprint_hash']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('license_activations');
    }
};
