<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $title ?? 'License Admin' }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="font-family: Arial, sans-serif; padding: 18px; max-width: 1100px; margin: 0 auto;">
    <div style="display:flex; justify-content:space-between; align-items:center; gap:12px;">
        <h2 style="margin:0;">License Admin</h2>
        <div style="display:flex; gap:10px;">
            <a href="{{ route('admin.licenses.index') }}">Licenses</a>
            <a href="{{ route('admin.licenses.create') }}">Generate</a>
        </div>
    </div>

    <hr style="margin: 14px 0;">

    @if (session('success'))
        <div style="padding:10px; background:#e5ffe9; border:1px solid #b7f5c5; margin-bottom:12px;">
            {{ session('success') }}
        </div>
    @endif

    @if ($errors->any())
        <div style="padding:10px; background:#ffe5e5; border:1px solid #f5b7b7; margin-bottom:12px;">
            <ul style="margin:0; padding-left:18px;">
                @foreach ($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @yield('content')
</body>
</html>
