@extends('admin.layout', ['title' => 'Licenses'])

@section('content')
    <form method="GET" action="{{ route('admin.licenses.index') }}" style="display:flex; gap:10px; align-items:center; margin-bottom:12px;">
        <input type="text" name="q" value="{{ $q }}" placeholder="Search key..." style="padding:8px; width:320px;">
        <select name="status" style="padding:8px;">
            <option value="">All Status</option>
            @foreach (['new','active','revoked','blocked'] as $st)
                <option value="{{ $st }}" @selected($status === $st)>{{ strtoupper($st) }}</option>
            @endforeach
        </select>
        <button type="submit" style="padding:8px 12px;">Filter</button>
        <a href="{{ route('admin.licenses.create') }}" style="margin-left:auto;">+ Generate New</a>
    </form>

    @if (session('generated_keys'))
        <div style="padding:10px; background:#f2f7ff; border:1px solid #cfe2ff; margin-bottom:12px;">
            <strong>Generated Keys:</strong>
            <div style="margin-top:8px; font-family: monospace; white-space: pre-wrap;">
                {{ implode("\n", session('generated_keys')) }}
            </div>
        </div>
    @endif

    <table border="1" cellpadding="8" cellspacing="0" style="width:100%; border-collapse:collapse;">
        <thead>
            <tr>
                <th>Key</th>
                <th>Status</th>
                <th>Max</th>
                <th>Activations</th>
                <th>Expires</th>
                <th>Created</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        @forelse ($licenses as $l)
            <tr>
                <td style="font-family: monospace;">{{ $l->key }}</td>
                <td>{{ strtoupper($l->status) }}</td>
                <td>{{ $l->max_activations }}</td>
                <td>{{ $l->activations_count }}</td>
                <td>{{ $l->expires_at ? $l->expires_at->format('Y-m-d') : '-' }}</td>
                <td>{{ $l->created_at->format('Y-m-d H:i') }}</td>
                <td>
                    <a href="{{ route('admin.licenses.show', $l) }}">View</a>
                </td>
            </tr>
        @empty
            <tr><td colspan="7">No licenses found.</td></tr>
        @endforelse
        </tbody>
    </table>

    <div style="margin-top:12px;">
        {{ $licenses->links() }}
    </div>
@endsection
