@extends('admin.layout', ['title' => 'License Details'])

@section('content')
    <h3 style="margin-top:0;">License Details</h3>

    <div style="padding:10px; border:1px solid #ddd; margin-bottom:12px;">
        <div><strong>Key:</strong> <span style="font-family: monospace;">{{ $license->key }}</span></div>
        <div><strong>Status:</strong> {{ strtoupper($license->status) }}</div>
        <div><strong>Max Activations:</strong> {{ $license->max_activations }}</div>
        <div><strong>Expires:</strong> {{ $license->expires_at ? $license->expires_at->format('Y-m-d H:i') : '-' }}</div>
        <div><strong>Created:</strong> {{ $license->created_at->format('Y-m-d H:i') }}</div>
    </div>

    <div style="display:flex; gap:10px; flex-wrap:wrap; margin-bottom:12px;">
        <form method="POST" action="{{ route('admin.licenses.reset', $license) }}">
            @csrf
            <button type="submit" style="padding:8px 12px;">Reset Activations</button>
        </form>

        <form method="POST" action="{{ route('admin.licenses.status', $license) }}">
            @csrf
            <input type="hidden" name="status" value="revoked">
            <button type="submit" style="padding:8px 12px;">Revoke</button>
        </form>

        <form method="POST" action="{{ route('admin.licenses.status', $license) }}">
            @csrf
            <input type="hidden" name="status" value="blocked">
            <button type="submit" style="padding:8px 12px;">Block</button>
        </form>

        <form method="POST" action="{{ route('admin.licenses.status', $license) }}">
            @csrf
            <input type="hidden" name="status" value="active">
            <button type="submit" style="padding:8px 12px;">Set Active</button>
        </form>

        <form method="POST" action="{{ route('admin.licenses.status', $license) }}">
            @csrf
            <input type="hidden" name="status" value="new">
            <button type="submit" style="padding:8px 12px;">Set New</button>
        </form>

        <form method="POST" action="{{ route('admin.licenses.delete', $license) }}" onsubmit="return confirm('Delete license?')">
            @csrf
            @method('DELETE')
            <button type="submit" style="padding:8px 12px;">Delete</button>
        </form>
    </div>

    <h4>Activations</h4>

    <table border="1" cellpadding="8" cellspacing="0" style="width:100%; border-collapse:collapse;">
        <thead>
        <tr>
            <th>Domain</th>
            <th>Fingerprint Hash</th>
            <th>IP</th>
            <th>Activated At</th>
            <th>Last Check</th>
            <th>App Version</th>
        </tr>
        </thead>
        <tbody>
        @forelse ($license->activations as $a)
            <tr>
                <td>{{ $a->domain ?? '-' }}</td>
                <td style="font-family: monospace; font-size: 12px;">{{ $a->fingerprint_hash }}</td>
                <td>{{ $a->ip ?? '-' }}</td>
                <td>{{ $a->activated_at ? $a->activated_at->format('Y-m-d H:i') : '-' }}</td>
                <td>{{ $a->last_check_at ? $a->last_check_at->format('Y-m-d H:i') : '-' }}</td>
                <td>{{ $a->app_version ?? '-' }}</td>
            </tr>
        @empty
            <tr><td colspan="6">No activations yet.</td></tr>
        @endforelse
        </tbody>
    </table>
@endsection
