<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LicenseAdminController;


Route::get('/', function () {
    return view('welcome');
});





Route::redirect('/', '/admin/licenses');

Route::middleware(['web', 'admin.basic'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/licenses', [LicenseAdminController::class, 'index'])->name('licenses.index');
    Route::get('/licenses/create', [LicenseAdminController::class, 'create'])->name('licenses.create');
    Route::post('/licenses', [LicenseAdminController::class, 'store'])->name('licenses.store');

    Route::get('/licenses/{license}', [LicenseAdminController::class, 'show'])->name('licenses.show');

    Route::post('/licenses/{license}/reset', [LicenseAdminController::class, 'resetActivations'])->name('licenses.reset');
    Route::post('/licenses/{license}/status', [LicenseAdminController::class, 'setStatus'])->name('licenses.status');

    Route::delete('/licenses/{license}', [LicenseAdminController::class, 'delete'])->name('licenses.delete');
});
