

<?php $__env->startSection('content'); ?>
    <h3 style="margin-top:0;">License Details</h3>

    <div style="padding:10px; border:1px solid #ddd; margin-bottom:12px;">
        <div><strong>Key:</strong> <span style="font-family: monospace;"><?php echo e($license->key); ?></span></div>
        <div><strong>Status:</strong> <?php echo e(strtoupper($license->status)); ?></div>
        <div><strong>Max Activations:</strong> <?php echo e($license->max_activations); ?></div>
        <div><strong>Expires:</strong> <?php echo e($license->expires_at ? $license->expires_at->format('Y-m-d H:i') : '-'); ?></div>
        <div><strong>Created:</strong> <?php echo e($license->created_at->format('Y-m-d H:i')); ?></div>
    </div>

    <div style="display:flex; gap:10px; flex-wrap:wrap; margin-bottom:12px;">
        <form method="POST" action="<?php echo e(route('admin.licenses.reset', $license)); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit" style="padding:8px 12px;">Reset Activations</button>
        </form>

        <form method="POST" action="<?php echo e(route('admin.licenses.status', $license)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="status" value="revoked">
            <button type="submit" style="padding:8px 12px;">Revoke</button>
        </form>

        <form method="POST" action="<?php echo e(route('admin.licenses.status', $license)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="status" value="blocked">
            <button type="submit" style="padding:8px 12px;">Block</button>
        </form>

        <form method="POST" action="<?php echo e(route('admin.licenses.status', $license)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="status" value="active">
            <button type="submit" style="padding:8px 12px;">Set Active</button>
        </form>

        <form method="POST" action="<?php echo e(route('admin.licenses.status', $license)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="status" value="new">
            <button type="submit" style="padding:8px 12px;">Set New</button>
        </form>

        <form method="POST" action="<?php echo e(route('admin.licenses.delete', $license)); ?>" onsubmit="return confirm('Delete license?')">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" style="padding:8px 12px;">Delete</button>
        </form>
    </div>

    <h4>Activations</h4>

    <table border="1" cellpadding="8" cellspacing="0" style="width:100%; border-collapse:collapse;">
        <thead>
        <tr>
            <th>Domain</th>
            <th>Fingerprint Hash</th>
            <th>IP</th>
            <th>Activated At</th>
            <th>Last Check</th>
            <th>App Version</th>
        </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $license->activations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($a->domain ?? '-'); ?></td>
                <td style="font-family: monospace; font-size: 12px;"><?php echo e($a->fingerprint_hash); ?></td>
                <td><?php echo e($a->ip ?? '-'); ?></td>
                <td><?php echo e($a->activated_at ? $a->activated_at->format('Y-m-d H:i') : '-'); ?></td>
                <td><?php echo e($a->last_check_at ? $a->last_check_at->format('Y-m-d H:i') : '-'); ?></td>
                <td><?php echo e($a->app_version ?? '-'); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="6">No activations yet.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', ['title' => 'License Details'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\license-server\resources\views/admin/licenses/show.blade.php ENDPATH**/ ?>